<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) & !(IE 8)]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->

<!--head start -->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<!-- <meta name="viewport" content="width=device-width"> -->
	<title><?php wp_title( '|', true, 'right' ); ?></title>
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php wp_head(); ?>
</head>
<!-- head end -->

<!-- body start -->
<body>
	
	<!-- header start -->
	<header>
		
		<!-- logo image -->
		<div id="logo"></div>
		
		<!-- blog title start -->
		<div id="blogtitle">
			<div id="searchform"><?php include(TEMPLATEPATH . '/searchform.php'); ?></div>
			<h1 id="title"><a href="<?php echo get_option('home'); ?>"><?php bloginfo('name'); ?></a></h1>
			<h2 id="description"><?php bloginfo('description'); ?></h2>
		</div>
		<!-- blog title end -->
		
		<!-- top menu start -->
		<nav id="menu-top" role="navigation">
			<ul>
				<!-- <li><a href="<?php bloginfo('url'); ?>">Home</a></li> -->
				<?php wp_nav_menu( array('theme_location' => 'top_header' )); ?>
			</ul>
		</nav>
		<!-- top menu end -->
		
	</header>
	<!-- header end -->